-- create constraints and indices script

-------------------------
-- create data table indices (41 indices)
-------------------------

select 'starting full indexing run' as message, to_char(sysdate,'MM-DD-YYYY HH24:MI:SS') as time from dual;

-------------------------
-- uniques (4 indices)
select 'creating uniques indices' as message, to_char(sysdate,'MM-DD-YYYY HH24:MI:SS') as time from dual;

alter table uniques add constraint uniques_key_PK_IDX primary key (u_key);
create unique index uniques_signed_IDX on uniques (u_signed) parallel (degree default) tablespace indx compute statistics;
create unique index uniques_code_CK_IDX on uniques (u_code) parallel (degree default) tablespace indx compute statistics;
create index uniques_name_IDX on uniques (u_name) parallel (degree default) tablespace indx compute statistics;

select 'finished creating uniques indices' as message, to_char(sysdate,'MM-DD-YYYY HH24:MI:SS') as time from dual;

-------------------------
-- hundred (6 indices)
select 'creating hundred indices' as message, to_char(sysdate,'MM-DD-YYYY HH24:MI:SS') as time from dual;

alter table hundred add constraint hundred_key_PK_IDX primary key (h_key) parallel (degree default);
create index hundred_int_IDX on hundred (h_int) parallel (degree default) tablespace indx compute statistics;
create index hundred_signed_IDX on hundred (h_signed) parallel (degree default) tablespace indx compute statistics;
create index hundred_date_IDX on hundred (h_date) parallel (degree default) tablespace indx compute statistics;
create unique index hundred_code_CK_IDX on hundred (h_code) parallel (degree default) tablespace indx compute statistics;
create index hundred_name_IDX on hundred (h_name) parallel (degree default) tablespace indx compute statistics;

select 'finished creating hundred indices' as message, to_char(sysdate,'MM-DD-YYYY HH24:MI:SS') as time from dual;

-------------------------
-- tenpct (9 indices)
select 'creating tenpct indices' as message, to_char(sysdate,'MM-DD-YYYY HH24:MI:SS') as time from dual;

alter table tenpct add constraint tenpct_key_code_PK_IDX primary key (t_key, t_code) parallel (degree default);
create index tenpct_int_IDX on tenpct (t_int) parallel (degree default) tablespace indx compute statistics;
create index tenpct_signed_IDX on tenpct (t_signed) parallel (degree default) tablespace indx compute statistics;
create index tenpct_float_IDX on tenpct (t_float) parallel (degree default) tablespace indx compute statistics;
create index tenpct_double_IDX on tenpct (t_double) parallel (degree default) tablespace indx compute statistics;
create index tenpct_decim_IDX on tenpct (t_decim) parallel (degree default) tablespace indx compute statistics;
create index tenpct_date_IDX on tenpct (t_date) parallel (degree default) tablespace indx compute statistics;
create unique index tenpct_code_CK_IDX on tenpct (t_code) parallel (degree default) tablespace indx compute statistics;
create index tenpct_name_IDX on tenpct (t_name) parallel (degree default) tablespace indx compute statistics;

select 'finished creating tenpct indices' as message, to_char(sysdate,'MM-DD-YYYY HH24:MI:SS') as time from dual;

-------------------------
-- updates (6 indices, 1 foreign key)
select 'creating updates indices' as message, to_char(sysdate,'MM-DD-YYYY HH24:MI:SS') as time from dual;

alter table updates add constraint updates_key_PK_IDX primary key (p_key) parallel (degree default);
create index updates_int_IDX on updates (p_int) parallel (degree default) tablespace indx compute statistics;
alter table updates add constraint updates_int_FK foreign key (p_int) references hundred (h_key) parallel (degree default);
create index updates_signed_IDX on updates (p_signed) parallel (degree default) tablespace indx compute statistics;
create index updates_decim_IDX on updates (p_decim) parallel (degree default) tablespace indx compute statistics;
create index updates_date_IDX on updates (p_date) parallel (degree default) tablespace indx compute statistics;
create unique index updates_code_CK_IDX on updates (p_code) parallel (degree default) tablespace indx compute statistics;

select 'finished creating updates indices' as message, to_char(sysdate,'MM-DD-YYYY HH24:MI:SS') as time from dual;

-------------------------
-- tenthou (5 indices)
select 'creating tenthou indices' as message, to_char(sysdate,'MM-DD-YYYY HH24:MI:SS') as time from dual;

alter table tenthou add constraint tenthou_key_code_PK_IDX primary key (t_key, t_code) parallel (degree default);
create index tenthou_signed_IDX on tenthou (t_signed) parallel (degree default) tablespace indx compute statistics;
create index tenthou_decim_IDX on tenthou (t_decim) parallel (degree default) tablespace indx compute statistics;
create unique index tenthou_code_CK_IDX on tenthou (t_code) parallel (degree default) tablespace indx compute statistics;
create index tenthou_name_IDX on tenthou (t_name) parallel (degree default) tablespace indx compute statistics;

select 'finished creating tenthou indices' as message, to_char(sysdate,'MM-DD-YYYY HH24:MI:SS') as time from dual;

-------------------------
-- hunthou (1 index)
select 'creating hunthou indices' as message, to_char(sysdate,'MM-DD-YYYY HH24:MI:SS') as time from dual;

create index hunthou_signed_IDX on hunthou (h_signed) parallel (degree default) tablespace indx compute statistics;

select 'finished creating hunthou indices' as message, to_char(sysdate,'MM-DD-YYYY HH24:MI:SS') as time from dual;

-------------------------
-- twomill (3 indices)
select 'creating twomill indices' as message, to_char(sysdate,'MM-DD-YYYY HH24:MI:SS') as time from dual;

alter table twomill add constraint twomill_key_PK_IDX primary key (p_key) parallel (degree default);
create index twomill_date_IDX on twomill (p_date) parallel (degree default) tablespace indx compute statistics;
create unique index twomill_code_CK_IDX on twomill (p_code) parallel (degree default) tablespace indx compute statistics;

select 'finished creating twomill indices' as message, to_char(sysdate,'MM-DD-YYYY HH24:MI:SS') as time from dual;

-------------------------
-- threemill (2 indices)
select 'creating threemill indices' as message, to_char(sysdate,'MM-DD-YYYY HH24:MI:SS') as time from dual;

alter table threemill add constraint threemill_key_PK_IDX primary key (t_key) parallel (degree default);
create index threemill_signed_IDX on threemill (t_signed) parallel (degree default) tablespace indx compute statistics;

select 'finished creating threemill indices' as message, to_char(sysdate,'MM-DD-YYYY HH24:MI:SS') as time from dual;

-------------------------
-- fourmill (2 indices)
select 'creating fourmill indices' as message, to_char(sysdate,'MM-DD-YYYY HH24:MI:SS') as time from dual;

alter table fourmill add constraint fourmill_key_PK_IDX primary key (t_key) parallel (degree default);
create index fourmill_name_IDX on fourmill (t_name) parallel (degree default) tablespace indx compute statistics;

select 'finished creating fourmill indices' as message, to_char(sysdate,'MM-DD-YYYY HH24:MI:SS') as time from dual;

-------------------------
-- fivemill (2 indices)
select 'creating fivemill indices' as message, to_char(sysdate,'MM-DD-YYYY HH24:MI:SS') as time from dual;

alter table fivemill add constraint fivemill_key_PK_IDX primary key (h_key) parallel (degree default);
create unique index fivemill_code_CK_IDX on fivemill (h_code) parallel (degree default) tablespace indx compute statistics;

select 'finished creating fivemill indices' as message, to_char(sysdate,'MM-DD-YYYY HH24:MI:SS') as time from dual;

-------------------------
-- fourram (1 index)
select 'creating fourram indices' as message, to_char(sysdate,'MM-DD-YYYY HH24:MI:SS') as time from dual;

alter table fourram add constraint fourram_key_PK_IDX primary key (p_key) parallel (degree default);

select 'finished creating fourram indices' as message, to_char(sysdate,'MM-DD-YYYY HH24:MI:SS') as time from dual;

-------------------------
-- create housekeeping table indices (5 indices)
-------------------------

-- update_int_history (2 indices)
select 'creating update_int_history indices' as message, to_char(sysdate,'MM-DD-YYYY HH24:MI:SS') as time from dual;

alter table update_int_history add constraint up_int_hist_key_int_PK_IDX primary key (p_key, p_int) parallel (degree default);
create index update_int_history_int_IDX on update_int_history (p_int) parallel (degree default) tablespace indx compute statistics;

select 'finished creating update_int_history indices' as message, to_char(sysdate,'MM-DD-YYYY HH24:MI:SS') as time from dual;

-- update_signed_history (2 indices)
select 'creating update_signed_history indices' as message, to_char(sysdate,'MM-DD-YYYY HH24:MI:SS') as time from dual;

alter table update_signed_history add constraint up_sign_hist_key_sign_PK_IDX primary key (p_key, p_signed) parallel (degree default);
create index up_sign_hist_sign_IDX on update_signed_history (p_signed) parallel (degree default) tablespace indx compute statistics;

select 'finished creating update_signed_history indices' as message, to_char(sysdate,'MM-DD-YYYY HH24:MI:SS') as time from dual;

-- del_history (1 index)
select 'creating del_history indices' as message, to_char(sysdate,'MM-DD-YYYY HH24:MI:SS') as time from dual;

alter table del_history add constraint del_history_key_PK_IDX primary key (h_key) parallel (degree default);

select 'finished creating del_history indices' as message, to_char(sysdate,'MM-DD-YYYY HH24:MI:SS') as time from dual;

-------------------------
-- end
-------------------------

select 'finished full indexing run' as message, to_char(sysdate,'MM-DD-YYYY HH24:MI:SS') as time from dual;

commit;
exit
